/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.ai;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import vazkii.quark.content.mobs.entity.Foxhound;

public class FindPlaceToSleepGoal
extends MoveToBlockGoal {
    private final Foxhound foxhound;
    private final Target target;
    private boolean hadSlept = false;

    public FindPlaceToSleepGoal(Foxhound foxhound, double speed, Target target) {
        super((PathfinderMob)foxhound, speed, 8);
        this.foxhound = foxhound;
        this.target = target;
    }

    public boolean m_8036_() {
        return this.foxhound.m_21824_() && !this.foxhound.m_21827_() && super.m_8036_();
    }

    public boolean m_8045_() {
        return (!this.hadSlept || this.foxhound.m_5803_()) && super.m_8045_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.hadSlept = false;
        this.foxhound.m_21839_(false);
        this.foxhound.getSleepGoal().setSleeping(false);
        this.foxhound.m_21837_(false);
    }

    public void m_8041_() {
        super.m_8041_();
        this.hadSlept = false;
        this.foxhound.m_21839_(false);
        this.foxhound.getSleepGoal().setSleeping(false);
        this.foxhound.m_21837_(false);
    }

    public void m_8037_() {
        super.m_8037_();
        Vec3 motion = this.foxhound.m_20184_();
        if (!this.m_25625_() || motion.f_82479_ > 0.0 || motion.f_82481_ > 0.0) {
            this.foxhound.m_21839_(false);
            this.foxhound.getSleepGoal().setSleeping(false);
            this.foxhound.m_21837_(false);
        } else if (!this.foxhound.m_21827_()) {
            this.foxhound.m_21839_(true);
            this.foxhound.getSleepGoal().setSleeping(true);
            this.foxhound.m_21837_(true);
            this.foxhound.m_5802_(this.f_25602_.m_7494_());
            this.hadSlept = true;
        }
    }

    protected boolean m_6465_(@Nonnull LevelReader world, @Nonnull BlockPos pos) {
        if (!world.m_46859_(pos.m_7494_())) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        BlockEntity tileentity = world.m_7702_(pos);
        return switch (this.target) {
            default -> throw new IncompatibleClassChangeError();
            case Target.LIT_FURNACE -> {
                if (tileentity instanceof FurnaceBlockEntity && state.getLightEmission((BlockGetter)world, pos) > 2) {
                    yield true;
                }
                yield false;
            }
            case Target.FURNACE -> {
                if (tileentity instanceof FurnaceBlockEntity && state.getLightEmission((BlockGetter)world, pos) <= 2) {
                    yield true;
                }
                yield false;
            }
            case Target.GLOWING -> state.getLightEmission((BlockGetter)world, pos) > 2;
        };
    }

    public static enum Target {
        LIT_FURNACE,
        FURNACE,
        GLOWING;

    }
}

